/****** Object:  Trigger [[TRG_EST_NF_SAI_INCLUI_PENDENCIA]]    Script Date: 01/22/2014 12:31:46 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_SAI_INCLUI_PENDENCIA]'))
DROP TRIGGER [dbo].[TRG_EST_NF_SAI_INCLUI_PENDENCIA]
GO
GO
GO
GO

-------------------------------------INSIRO EM EST_NF_SAI--------------------------------------
CREATE TRIGGER [dbo].[TRG_EST_NF_SAI_INCLUI_PENDENCIA] ON [dbo].[EST_NF_SAI] FOR INSERT AS
--Pendncia de entrada de nota fiscal de transferencia
INSERT INTO EST_NF_SAI_PENDENCIA (  --  
	CD_EMP, 
	CD_FILIAL, 
	CD_NF, 
	CD_FILIAL_DEST)
    SELECT 
		DISTINCT CD_EMP, 
		CD_FILIAL, 
		CD_NF, 
		CD_CLI
    FROM 
		INSERTED s
    WHERE 
		STS_NF=0 
		AND PEND_ENTRADA=0  --nao cancelada, pendente de entrada
		AND CD_NT_MOV IN (SELECT CD_MOV_OP FROM GLB_MOV_OP WHERE DEST_ORIG=2 AND TP_MOV <> 28) --origem filial
		AND NOT EXISTS (SELECT 
						* 
					  FROM 
						EST_NF_ENT_EST_NF_SAI_TRANSF 
					  WHERE 
						CD_NF_SAI=s.CD_NF AND 
						CD_EMP=s.CD_EMP AND 
						CD_FIL_ORIG=s.CD_FILIAL)
	   		AND NOT EXISTS (SELECT 
						* 
					  FROM 
						EST_NF_SAI_PENDENCIA p 
					  WHERE 
						p.CD_NF=s.CD_NF AND 
						p.CD_EMP=s.CD_EMP AND 
						p.CD_FILIAL=s.CD_FILIAL);
	--Pendncia de entrada vendas grupo econmico
	INSERT INTO EST_NF_SAI_PENDENCIA(
				CD_EMP, 
				CD_FILIAL, 
				CD_NF, 
				CD_FILIAL_DEST)
		SELECT 
			DISTINCT
			s.CD_EMP, 
			s.CD_FILIAL, 
			s.CD_NF, 
			r.CD_FILIAL
		FROM 
			INSERTED s INNER JOIN PRC_FILIAL_RC_CLI r ON 
			s.CD_EMP=r.CD_EMP AND 
			s.CD_CLI=r.CD_CLI
		WHERE 
			s.STS_NF=0 
			AND s.PEND_ENTRADA=0                 --transacao de saida, preco custo
			AND CD_NT_MOV IN (SELECT CD_MOV_OP FROM GLB_MOV_OP 
								WHERE TP_MOV_OP_TRANSA=1 AND DEST_ORIG= 0 AND TP_MOV <> 28)
			AND s.CD_FILIAL <> r.CD_FILIAL
			AND NOT EXISTS (SELECT 
								* 
							FROM 
								EST_NF_ENT_EST_NF_SAI_TRANSF   --ainda sem registro de transferncia
							WHERE 
								CD_NF_SAI=s.CD_NF AND 
								CD_EMP=s.CD_EMP AND 
								CD_FIL_ORIG=s.CD_FILIAL and
								CD_FIL_DEST= r.CD_FILIAL)
			AND NOT EXISTS (SELECT 
								*
							FROM 
								EST_NF_SAI_PENDENCIA
							WHERE 
								CD_FILIAL=s.CD_FILIAL AND 
								CD_EMP=s.CD_EMP AND 
								CD_NF=s.CD_NF);
	--Pendente de entrada outras saidas para o grupo econmico
	INSERT INTO EST_NF_SAI_PENDENCIA(
				CD_EMP, 
				CD_FILIAL, 
				CD_NF, 
				CD_FILIAL_DEST)
		SELECT 
				DISTINCT
				s.CD_EMP, 
				s.CD_FILIAL AS CD_FILIAL_ORIG, 
				s.CD_NF, 
				f.CD_FILIAL AS CD_FILIAL_DEST
		FROM 
			INSERTED s INNER JOIN PRC_FILIAL_PG_FORN f ON 
			s.CD_EMP=f.CD_EMP AND 
			s.CD_CLI=f.CD_FORN AND 
			s.CD_FILIAL <> f.CD_FILIAL
		WHERE 
			s.STS_NF=0 
			AND s.PEND_ENTRADA=0 --transacao de saida, preco custo
			AND CD_NT_MOV IN (SELECT CD_MOV_OP FROM GLB_MOV_OP WHERE TP_MOV_OP_TRANSA=1 AND DEST_ORIG=1 AND TP_MOV <> 28)
			AND NOT EXISTS (SELECT 
								* 
							FROM 
								EST_NF_ENT_EST_NF_SAI_TRANSF
						  WHERE 
								CD_NF_SAI=s.CD_NF 
								AND CD_EMP=s.CD_EMP 
								AND CD_FIL_ORIG=s.CD_FILIAL)
			AND NOT EXISTS (SELECT 
								* 
						  FROM 
								EST_NF_SAI_PENDENCIA
						  WHERE 
								CD_FILIAL=s.CD_FILIAL AND 
								CD_EMP=s.CD_EMP AND 
								CD_NF=s.CD_NF);

GO


